<?php
/*
 * Template name: Страница Поддержка
 */
?>

<?php get_header(); ?>

<section class="u60">
<div class="u7">
	<h1 class="u94"><?php the_field( 'zagolovok_supp-1' ); ?></h1>
	<p class="u63"><?php the_field( 'tekst_pod_zagolovkom_supp-1' ); ?></p>
	<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="u61 u59">Подключить через Telegram</a>
	</div>
</section>

<section class="u76">
            <div class="u7">
                <div class="u12">
                    <h2><?php the_field( 'zagolovok_bloka_diagn' ); ?></h2>
                    <p><?php the_field( 'tekst_pod_zagolovkom_diagn' ); ?></p>
                    <div class="u11">
                        <button class="u75" data-problem="connection">Не подключается</button>
                        <button class="u75" data-problem="speed">Медленно работает</button>
                        <button class="u75" data-problem="blocked">Сайты заблокированы</button>
                        <button class="u75" data-problem="other">Другая проблема</button>
                    </div>
                </div>
            </div>
        </section>

        <section class="u77">
            <div class="u7">
                <div class="u68">
                    <div class="u66" id="solution-connection" style="display: none;">
                        <h3>Проблемы с подключением</h3>
                        <div class="u67">
							<?php if ( have_rows( 'problemy_s_podklyucheniem_diag' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag' ) ) : the_row(); ?>
                            <div class="u69">
                                <div class="u73"><?php the_sub_field( 'nomer_shaga_diagn' ); ?></div>
                                <div class="u71">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="u66" id="solution-speed" style="display: none;">
                        <h3>Медленная скорость</h3>
                        <div class="u67">
							<?php if ( have_rows( 'problemy_s_podklyucheniem_diag_1' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_1' ) ) : the_row(); ?>
                            <div class="u69">
                                <div class="u73"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="u71">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="u66" id="solution-blocked" style="display: none;">
                        <h3>Сайты остаются заблокированными</h3>
                        <div class="u67">
                            <?php if ( have_rows( 'problemy_s_podklyucheniem_diag_2' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_2' ) ) : the_row(); ?>
                            <div class="u69">
                                <div class="u73"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="u71">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="u66" id="solution-other" style="display: none;">
                        <h3>Другие проблемы</h3>
                        <div class="u67">
                            <?php if ( have_rows( 'problemy_s_podklyucheniem_diag_3' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_3' ) ) : the_row(); ?>
                            <div class="u69">
                                <div class="u73"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="u71">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<section class="u20">
<div class="u7">
	<h2 class="u91">Частые вопросы</h2>
	<div class="u21">
<?php if ( have_rows( 'vopros-otvet' ) ) : ?>
	<?php while ( have_rows( 'vopros-otvet' ) ) : the_row(); ?>			
<details class="u8" name="faq">
  <summary class="u10"><?php the_sub_field( 'vopros' ); ?></summary>
  <div class="u9">
    <p><?php the_sub_field( 'otvet' ); ?></p>
  </div>
</details>
	<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>			
	</div>
	</div>
</section>

<script>
    // Global state
let currentPlatform = "windows";
let detectedOS = null;

// DOM Ready
document.addEventListener("DOMContentLoaded", function () {
  initializeApp();
});


    function initializeApp() {
  document.querySelectorAll(".support-btn").forEach((btn) => {
    btn.addEventListener("click", function () {
      const problem = this.dataset.problem;
      showSolution(problem);

      // Update active state
      document
        .querySelectorAll(".support-btn")
        .forEach((b) => b.classList.remove("active"));
      this.classList.add("active");
    });
  });
}

function showSolution(problem) {
  // Hide all solutions
  document.querySelectorAll(".solution-card").forEach((card) => {
    card.style.display = "none";
  });

  // Show selected solution
  const solutionCard = document.getElementById(`solution-${problem}`);
  if (solutionCard) {
    solutionCard.style.display = "block";
    solutionCard.scrollIntoView({ behavior: "smooth", block: "center" });
  }
}
</script>

<?php get_footer(); ?>