<?php get_header(); ?>

<section class="main">
<div class="container">
	<div class="main__block">
		<h1 class="h1 animated-fade-in"><?php the_field( 'zagolovok_home' ); ?></h1>
		<p class="text animated-fade-in"><?php the_field( 'tekst_pod_zagolovkom_home' ); ?></p>
		<div class="main__button animated-fade-in">
			<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="main__button-b">Получить ключ</a>
			<a href="#why-us" class="main__button-c">Узнать больше</a>
		</div>
		<div class="main__card animated-fade-in">
			<?php if ( have_rows( 'preimushhestva_home' ) ) : ?>
	<?php while ( have_rows( 'preimushhestva_home' ) ) : the_row(); ?>
			<div class="main__card-item">
				<span class="main__numb"><?php the_sub_field( 'tekst_v_pervoj_stroke' ); ?></span>
				<span class="main__text"><?php the_sub_field( 'tekst_vo_vtoroj_stroke' ); ?></span>
			</div>
			<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
		</div>
	</div>
	</div>
</section>

<section id="why-us" class="why-us">
<div class="container">
	<h2 class="h2"><?php the_field( 'zagolovok_bloka_pochemu_vybirayut' ); ?></h2>
	<div class="why-us__block">
		<?php if ( have_rows( 'kartochki_bloka_home' ) ) : ?>
	<?php while ( have_rows( 'kartochki_bloka_home' ) ) : the_row(); ?>
		<div class="why-us__item">
			<div class="why-us__icon">
				<?php the_sub_field( 'kod_ikonki_svg' ); ?>
			</div>
			<h3><?php the_sub_field( 'zagolovok_card_home' ); ?></h3>
			<p><?php the_sub_field( 'tekst_card_home' ); ?></p>
		</div>
		<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
	</div>
	</div>
</section>

 <!-- Servers Section -->
  <section class="servers" id="servers">
    <div class="container">
      <div class="section-header">
        <h2 class="h2" style="margin-bottom: 24px;">Серверы по всему миру</h2>
        <p>Высокоскоростные серверы для
          <?php the_field('brand1', 'option'); ?> в ключевых локациях для оптимального соединения</p>
      </div>

      <div class="servers-grid">
        <div class="server-card">
          <div class="server-header">
            <div class="server-flag">🇺🇸</div>
            <div class="server-info">
              <h3>США</h3>
              <p>Нью-Йорк, Лос-Анджелес</p>
            </div>
          </div>
          <div class="server-stats">
            <div class="server-stat">
              <span class="server-stat-value">15ms</span>
              <span class="server-stat-label">Пинг</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">25 Gbps</span>
              <span class="server-stat-label">Скорость</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">99.9%</span>
              <span class="server-stat-label">Аптайм</span>
            </div>
          </div>
          <div class="server-status">Онлайн</div>
        </div>

        <div class="server-card">
          <div class="server-header">
            <div class="server-flag">🇰🇿</div>
            <div class="server-info">
              <h3>Казахстан</h3>
              <p>Алматы</p>
            </div>
          </div>
          <div class="server-stats">
            <div class="server-stat">
              <span class="server-stat-value">12ms</span>
              <span class="server-stat-label">Пинг</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">25 Gbps</span>
              <span class="server-stat-label">Скорость</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">99.8%</span>
              <span class="server-stat-label">Аптайм</span>
            </div>
          </div>
          <div class="server-status">Онлайн</div>
        </div>

        <div class="server-card">
          <div class="server-header">
            <div class="server-flag">🇩🇪</div>
            <div class="server-info">
              <h3>Германия</h3>
              <p>Франкфурт, Берлин</p>
            </div>
          </div>
          <div class="server-stats">
            <div class="server-stat">
              <span class="server-stat-value">8ms</span>
              <span class="server-stat-label">Пинг</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">25 Gbps</span>
              <span class="server-stat-label">Скорость</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">99.9%</span>
              <span class="server-stat-label">Аптайм</span>
            </div>
          </div>
          <div class="server-status">Онлайн</div>
        </div>

        <div class="server-card">
          <div class="server-header">
            <div class="server-flag">🇯🇵</div>
            <div class="server-info">
              <h3>Япония</h3>
              <p>Токио, Осака</p>
            </div>
          </div>
          <div class="server-stats">
            <div class="server-stat">
              <span class="server-stat-value">25ms</span>
              <span class="server-stat-label">Пинг</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">25 Gbps</span>
              <span class="server-stat-label">Скорость</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">99.7%</span>
              <span class="server-stat-label">Аптайм</span>
            </div>
          </div>
          <div class="server-status">Онлайн</div>
        </div>

        <div class="server-card">
          <div class="server-header">
            <div class="server-flag">🇷🇺</div>
            <div class="server-info">
              <h3>Россия</h3>
              <p>Москва</p>
            </div>
          </div>
          <div class="server-stats">
            <div class="server-stat">
              <span class="server-stat-value">18ms</span>
              <span class="server-stat-label">Пинг</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">25 Gbps</span>
              <span class="server-stat-label">Скорость</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">99.9%</span>
              <span class="server-stat-label">Аптайм</span>
            </div>
          </div>
          <div class="server-status">Онлайн</div>
        </div>

        <div class="server-card">
          <div class="server-header">
            <div class="server-flag">🇨🇦</div>
            <div class="server-info">
              <h3>Канада</h3>
              <p>Торонто, Ванкувер</p>
            </div>
          </div>
          <div class="server-stats">
            <div class="server-stat">
              <span class="server-stat-value">20ms</span>
              <span class="server-stat-label">Пинг</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">25 Gbps</span>
              <span class="server-stat-label">Скорость</span>
            </div>
            <div class="server-stat">
              <span class="server-stat-value">99.8%</span>
              <span class="server-stat-label">Аптайм</span>
            </div>
          </div>
          <div class="server-status">Онлайн</div>
        </div>
      </div>
    </div>
  </section>

<section class="faq">
<div class="container">
	<h2 class="h2">Частые вопросы</h2>
	<div class="faq__block">
<?php if ( have_rows( 'vopros-otvet' ) ) : ?>
	<?php while ( have_rows( 'vopros-otvet' ) ) : the_row(); ?>			
<details class="question" name="faq">
  <summary class="question__title"><?php the_sub_field( 'vopros' ); ?></summary>
  <div class="question__content">
    <p><?php the_sub_field( 'otvet' ); ?></p>
  </div>
</details>
	<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>			
	</div>
	</div>
</section>

<section class="start-now">
<div class="container">
	<h2 class="h2-s">Протестируйте <?php the_field('brand1', 'option'); ?> в течение 7 дней</h2>
	<p class="start-now__text">Присоединяйтесь к миллионам пользователей, которые уже защищают свой интернет</p>
	<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="start-now__button">Получить ключ</a>
	</div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {

  let blocks = document.querySelectorAll('.why-us__item');



  function checkBlocksVisibility() {

    let windowHeight = window.innerHeight;



    blocks.forEach(block => {

      let blockPosition = block.getBoundingClientRect().top;



      if (blockPosition < windowHeight - 100) {

        block.style.opacity = "1";

        block.style.transform = "translateY(0)";

      } else {

        block.style.opacity = "0";

        block.style.transform = "translateY(50px)";

      }

    });

  }



  checkBlocksVisibility();



  window.addEventListener('scroll', checkBlocksVisibility);

});
</script>

<?php get_footer(); ?>