<?php
/*
 * Template name: Страница Поддержка
 */
?>

<?php get_header(); ?>

<section class="setup">
<div class="container">
	<h1 class="setup__title"><?php the_field( 'zagolovok_supp-1' ); ?></h1>
	<p class="setup__text"><?php the_field( 'tekst_pod_zagolovkom_supp-1' ); ?></p>
	<a href="<?php the_field( 'ssylka_na_knopkah', 'option' ); ?>" class="setup__button animated-fade-in">Подключить через Telegram</a>
	</div>
</section>

<section class="fast-diagnostic">
            <div class="container">
                <div class="fast-diagnostic__card">
                    <h2><?php the_field( 'zagolovok_bloka_diagn' ); ?></h2>
                    <p><?php the_field( 'tekst_pod_zagolovkom_diagn' ); ?></p>
                    <div class="fast-diagnostic__buttons">
                        <button class="fast-diagnostic__button" data-problem="connection">Не подключается</button>
                        <button class="fast-diagnostic__button" data-problem="speed">Медленно работает</button>
                        <button class="fast-diagnostic__button" data-problem="blocked">Сайты заблокированы</button>
                        <button class="fast-diagnostic__button" data-problem="other">Другая проблема</button>
                    </div>
                </div>
            </div>
        </section>

        <section class="solutions">
            <div class="container">
                <div class="solutions__wrapper">
                    <div class="solutions__card" id="solution-connection" style="display: none;">
                        <h3>Проблемы с подключением</h3>
                        <div class="solutions__steps">
							<?php if ( have_rows( 'problemy_s_podklyucheniem_diag' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag' ) ) : the_row(); ?>
                            <div class="solutions__step">
                                <div class="solutions__step-number"><?php the_sub_field( 'nomer_shaga_diagn' ); ?></div>
                                <div class="solutions__step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="solutions__card" id="solution-speed" style="display: none;">
                        <h3>Медленная скорость</h3>
                        <div class="solutions__steps">
							<?php if ( have_rows( 'problemy_s_podklyucheniem_diag_1' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_1' ) ) : the_row(); ?>
                            <div class="solutions__step">
                                <div class="solutions__step-number"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="solutions__step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="solutions__card" id="solution-blocked" style="display: none;">
                        <h3>Сайты остаются заблокированными</h3>
                        <div class="solutions__steps">
                            <?php if ( have_rows( 'problemy_s_podklyucheniem_diag_2' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_2' ) ) : the_row(); ?>
                            <div class="solutions__step">
                                <div class="solutions__step-number"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="solutions__step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>

                    <div class="solutions__card" id="solution-other" style="display: none;">
                        <h3>Другие проблемы</h3>
                        <div class="solutions__steps">
                            <?php if ( have_rows( 'problemy_s_podklyucheniem_diag_3' ) ) : ?>
	<?php while ( have_rows( 'problemy_s_podklyucheniem_diag_3' ) ) : the_row(); ?>
                            <div class="solutions__step">
                                <div class="solutions__step-number"><?php the_sub_field( 'nomer_shaga_diagn1' ); ?></div>
                                <div class="solutions__step-content">
                                    <h4><?php the_sub_field( 'zagolovok_shag_diagn1' ); ?></h4>
                                    <p><?php the_sub_field( 'tekst_shaga_diagn1' ); ?></p>
                                </div>
                            </div>
							<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<section class="faq">
<div class="container">
	<h2 class="h2">Частые вопросы</h2>
	<div class="faq__block">
<?php if ( have_rows( 'vopros-otvet' ) ) : ?>
	<?php while ( have_rows( 'vopros-otvet' ) ) : the_row(); ?>			
<details class="question" name="faq">
  <summary class="question__title"><?php the_sub_field( 'vopros' ); ?></summary>
  <div class="question__content">
    <p><?php the_sub_field( 'otvet' ); ?></p>
  </div>
</details>
	<?php endwhile; ?>
<?php else : ?>
	<?php // No rows found ?>
<?php endif; ?>			
	</div>
	</div>
</section>

<script>
    // Global state
let currentPlatform = "windows";
let detectedOS = null;

// DOM Ready
document.addEventListener("DOMContentLoaded", function () {
  initializeApp();
});


    function initializeApp() {
  document.querySelectorAll(".fast-diagnostic__button").forEach((btn) => {
    btn.addEventListener("click", function () {
      const problem = this.dataset.problem;
      showSolution(problem);

      // Update active state
      document
        .querySelectorAll(".fast-diagnostic__button")
        .forEach((b) => b.classList.remove("active"));
      this.classList.add("active");
    });
  });
}

function showSolution(problem) {
  // Hide all solutions
  document.querySelectorAll(".solutions__card").forEach((card) => {
    card.style.display = "none";
  });

  // Show selected solution
  const solutionCard = document.getElementById(`solution-${problem}`);
  if (solutionCard) {
    solutionCard.style.display = "block";
    solutionCard.scrollIntoView({ behavior: "smooth", block: "center" });
  }
}
</script>

<?php get_footer(); ?>